IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_UpdateRespondent]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[sp_UpdateRespondent]
GO

CREATE PROCEDURE [dbo].[sp_UpdateRespondent]  
	@ProjectId int,
	@UserId int,
	@CollectMode int,
	@ResRespondent varchar(10),
	@ResLanguage int,
	@ResTimeZone int,
	@ResCallBackDate DateTime,
	@ResIntervCall varchar(10),
	@ResTimeSlot int,
	@ResCallCount int,
	@ResLastCallDate datetime,
	@ResVersion varchar(10),
	@ResPriority int,
	@ResCompleted bit,
	@ResConfidPhone bit,
	@ResSeed float,
	@ResPhone varchar(20),
	@ResCodeResult varchar(2),
	@ResWaveNo int,
	@ResBlocked bit,
	@ResCompPredictive bit,
	@ResCall bit,
	@ResMonitored bit,
	@ResLastCompQuest int,
	@ResPreviousCallDate DateTime,
	@ResWaveImportNo int,
	@ServerTimeZone int,
	@DialingMode int = NULL, -- Null => Don't change;
	@IntLevel int = NULL, -- Null => Don't change;
	@RestrictionOverride bit = NULL, -- Null => Don't change;
	@CyclePhoneNumber bit
AS
	update Respondent set
		projectId = @ProjectId,
		collectMode = case when @CollectMode <0 then collectMode else @CollectMode end,
		modifiedBy = @UserId,
		modified = GETUTCDATE(),
		ResLanguage = @ResLanguage,
		ResTimeZone = @ResTimeZone,
		ResCallbackDate = dbo.[VX_fn_ToUTC](@ResCallBackDate, @ServerTimeZone),
		ResIntervCall = @ResIntervCall,
		ResTimeSlot = @ResTimeSlot,
		ResCallCount = @ResCallCount,
		ResLastCallDate = @ResLastCallDate,
		ResVersion = @ResVersion,
		ResPriority = @ResPriority,
		ResCompleted = @ResCompleted,
		ResConfidPhone = @ResConfidPhone,
		ResSeed = @ResSeed,
		Resphone = @ResPhone,
		ResCodeResult = @ResCodeResult,
		ResWaveNo = @ResWaveNo,
		ResBlocked = @ResBlocked,
		ResCompPredictive = @ResCompPredictive,
		ResCall = @ResCall,
		ResMonitored = @ResMonitored,
		ResLastCompQuest = @ResLastCompQuest,
		ResPreviousCallDate = @ResPreviousCallDate,
		ResWaveImportNo = @ResWaveImportNo,
		DialingMode = IsNull(@DialingMode,DialingMode), -- If not specified, leave original value
		IntLevel = IsNull(@IntLevel,IntLevel),
		RestrictionOverride = IsNull(@RestrictionOverride,RestrictionOverride),
		CyclePhoneNumber = @CyclePhoneNumber,
		ResCompletedDate = CASE WHEN ResCompleted = 0 AND @ResCompleted = 1 THEN GETUTCDATE() 
								WHEN ResCompleted = 1 AND @ResCompleted = 0 THEN NULL
								ELSE ResCompletedDate END
	where 
		ResRespondent = @ResRespondent

	if @@ROWCOUNT = 0
	begin
		-- Update Sequence table with max(resrespondent) from temp table if greather then the current sequence number
		declare @respondent bigint
		SET @respondent = cast(@ResRespondent as bigint)
		exec VX_SP_VerifyAndUpdateSequence 'Respondent',@respondent 

		insert into respondent
		(
			ResRespondent,
			ProjectId,
			CollectMode,
			ModifiedBy,
			Modified,
			ResLanguage,
			ResTimeZone,
			ResCallBackDate,
			ResIntervCall,
			ResTimeSlot,
			ResCallCount,
			ResLastCallDate,
			ResVersion,
			ResPriority,
			ResCompleted,
			ResConfidPhone,
			ResSeed,
			ResPhone,
			ResCodeResult,
			ResWaveNo,
			ResBlocked,
			ResCompPredictive,
			ResCall,
			ResMonitored,
			ResLastCompQuest,
			ResPreviousCallDate,
			ResWaveImportNo,
			DialingMode,
			IntLevel,
			RestrictionOverride,
			CyclePhoneNumber,
			ResCompletedDate )
		values
		(
			@ResRespondent,
			@ProjectId,
			@CollectMode,
			@UserId,
			GETUTCDATE(),
			@ResLanguage,
			@ResTimeZone,
			dbo.VX_fn_ToUTC(@ResCallBackDate, @ServerTimeZone),
			@ResIntervCall,
			@ResTimeSlot,
			@ResCallCount,
			@ResLastCallDate,
			@ResVersion,
			@ResPriority,
			@ResCompleted,
			@ResConfidPhone,
			@ResSeed,
			@ResPhone,
			@ResCodeResult,
			@ResWaveNo,
			@ResBlocked,
			@ResCompPredictive,
			@ResCall,
			@ResMonitored,
			@ResLastCompQuest,
			@ResPreviousCallDate,
			@ResWaveImportNo,
			IsNull(@DialingMode,0),
			IsNull(@IntLevel,0),
			IsNull(@RestrictionOverride,0),
			@CyclePhoneNumber,
			CASE WHEN @ResCompleted = 1 THEN GETUTCDATE() ELSE NULL END
		) 
end
